<section class="py-5" aria-labelledby="heizungsmodernisierung">
  <div class="container">
    <div class="row">
      <div class="col-md-12 text-center text-uppercase">
        <h1 id="heizungsmodernisierung">Heizungsmodernisierung mit Energieberater</h1>
      </div>
    </div>
    <div class="row">
      <div class="col-md-12">
        <p>Wer seine Heizkosten verringern und Energiekosten sparen möchte, der sollte die Modernisierung seiner Heizung angehen. Für die fachgerechte Umsetzung der technischen Details und für den sinnvollen Umstieg auf Erneuerbare Energien können Hausbesitzer auf einen Energieberater zurückgreifen. Der sichert zudem die staatlichen Fördergelder.</p>
      </div>
    </div>
  </div>
</section>

<section class="bg-grey py-5" aria-labelledby="foerdermoeglichkeiten">
  <div class="container">
    <div class="row">
      <div class="col-md-4">
        <h3 id="foerdermoeglichkeiten"><strong>Zuschüsse für Erneuerbare Energien-Heizungen</strong></h3>
        <p>prozentualer Zuschuss, je nach Anlage<br>von 30&nbsp;% bis zu 70&nbsp;%</p>
        <ul>
          <li>energieeffiziente Wärmepumpe</li>
          <li>Biomasse-Heizung</li>
          <li>Solarthermie-Anlage</li>
          <li>Anschluss an Fernwärme</li>
        </ul>
      </div>
      <div class="col-md-4">
        <h3><strong>Zuschüsse für Anlagen, die Wärme und Strom erzeugen</strong></h3>
        <ul>
          <li>Zuschuss für eine Brennstoffzellenheizung</li>
          <li>Landesförderungen und regionale Zuschüsse für Photovoltaik und PV-Speicher</li>
        </ul>
      </div>
      <div class="col-md-4">
        <h3><strong>Regionale Förderungen</strong></h3>
        <ul>
          <li>Über 2.600 Heizungsförderungen gibt es derzeit in Deutschland.</li>
          <li class="list-unstyled">&nbsp;</li>
          <li>Die Mehrzahl sind regionale Zuschüsse von Ländern, Städten, Gemeinden oder Energieversorgern.</li>
          <li class="list-unstyled">&nbsp;</li>
          <li>Regionale Förderungen können oft zusätzlich zu den staatlichen Programmen genutzt werden.</li>
        </ul>
        <div class="text-center">
          <a href="Immobilien" class="btn btn-warning">
            <i class="fa fa-arrow-right" aria-hidden="true"></i>&nbsp;<strong>Zur Förderauskunft</strong>
          </a>
        </div>
      </div>
    </div>
  </div>
</section>

<section class="py-5" aria-labelledby="energieeffizienz-experte">
  <div class="container">
    <div class="row">
      <div class="col-md-12 text-center">
        <h1 id="energieeffizienz-experte">Mit Energieeffizienz-Experte zur Förderung</h1>
        <h3 class="mt-0">Für eine staatliche Förderung ist ein gelisteter Energieeffizienz-Experte vor Ort Pflicht.</h3>
      </div>
    </div>
    <div class="row mt-4">
      <div class="col-md-12">
        <p>Die Sanierungsbegleitung unterstützt private Eigentümer von Ein- und Zweifamilienhäusern, die Ihre Immobilie energiesparend modernisieren möchten. Unabhängige Energieberater des Deutschen Energieberater-Netzwerks DEN e.V. begleiten die Modernisierung von der Planung bis zur Umsetzung vor Ort und sorgen dadurch für hohe Qualität und hohe Energieeinsparung. Die Berater wissen ganz genau, welche Fördergelder bereit stehen und wie der maximale Zuschuss erzielt wird.</p>
      </div>
    </div>
  </div>
</section>

<section class="bg-grey py-5" aria-labelledby="sanierungsfahrplan">
  <div class="container">
    <div class="row">
      <div class="col-md-4">
        <div class="text-center mb-3">
          <img src="pix/heizkesseltausch.png" class="img-fluid rounded-circle d-block mx-auto"  style="max-width: 50%;" alt="Heizkesseltausch">
        </div>
        <h3><strong>Sanierungsfahrplan zur umfassenden Erneuerung der Heizungsanlage</strong></h3>
        <p>Der auf eine Heizungsmodernisierung zugeschnittener Sanierungsfahrplan ist sinnvoll, wenn Sie:</p>
        <ul>
          <li>eine Heizungserneuerung im Haus planen und mit den Modernisierungsarbeiten noch nicht begonnen haben</li>
          <li>Weitere Modernisierungsmaßnahmen in den nächsten Jahren anstehen oder geplant sind</li>
          <li>staatliche Fördergelder nutzen wollen</li>
          <li>sich eine Begleitung über den gesamten Sanierungsprozess durch einen Energieberater wünschen</li>
        </ul>
      </div>
      <div class="col-md-4">
        <div class="text-center mb-3">
          <img src="pix/KFW-Antrag.png" class="img-fluid rounded-circle d-block mx-auto"  style="max-width: 50%;" alt="KFW Antrag">
        </div>
        <h3><strong>Staatliche Förderungen und maximale Energieeinsparung</strong></h3>
        <p>Die Sanierungsbegleitung ist zugeschnitten auf die staatlichen Förderprogramme:</p>
        <ul>
          <li>Energieberatung im Wohngebäude (EBW)</li>
          <li>Bundesförderung für effiziente Gebäude Einzelmaßnahmen BEG EM) Heizung (KfW) und Gebäudehülle (BAFA)</li>
        </ul>
      </div>
      <div class="col-md-4">
        <div class="text-center mb-3">
          <img src="pix/energieberater.png" class="img-fluid rounded-circle d-block mx-auto"  style="max-width: 50%;" alt="Energieberater">
        </div>
        <h3><strong>Ihr Komplettpaket unverbindlich anfragen</strong></h3>
        <ul>
          <li><strong>individuelle Energieberatung</strong></li>
          <li><strong>Sanierungsfahrplan</strong></li>
          <li><strong>Fördermittel</strong></li>
        </ul>
        <p><strong>So funktioniert es:</strong> Ihre Anfrage wird direkt an einen DEN-Energieberater in Ihrer Nähe übermittelt. Diese Vermittlung ist für Sie unverbindlich und kostenlos. Der Energieberater meldet sich innerhalb weniger Tage mit einem Angebot und zur Vereinbarung eines Vor-Ort-Termins bei Ihnen.</p>
        <div class="text-center">
          <a href="Kontakt" class="btn btn-warning">
            <i class="fa fa-arrow-right" aria-hidden="true"></i>&nbsp;<strong>Sanierungsfahrplan anfordern</strong>
          </a>
        </div>
      </div>
    </div>
  </div>
</section>

<section class="bg-dynamic py-5" aria-labelledby="kontakt-hotline">
  <div class="container">
    <div class="row">
      <div class="col-md-12 text-center">
        <h3 id="kontakt-hotline" class="text-color-white">Haben Sie Fragen zum Fördergeldservice?  Oder möchten wissen, wie Sie die Voraussetzungen zur Förderung Ihrer Heizung einhalten? Rufen Sie uns unter der Förder-Hotline an:<br>werktags von 9 Uhr bis 17 Uhr</h3>
        <h1 class="text-color-white">Förderhotline: 06190 9263-487</h1>
      </div>
    </div>
  </div>
</section>

<section class="py-5" aria-labelledby="beispiel-foerderung">
  <div class="container">
    <div class="row">
      <div class="col-md-12 text-center">
        <h1 id="beispiel-foerderung">Beispielförderung</h1>
        <h3 class="mt-0">Der tatsächliche Förderbetrag hängt von vielen Faktoren ab und berechnet sich individuell. Je nach Haus, vorhandener Heizungsanlage, neuer Heiztechnik und Umfang der Heizungsmodernisierung sowie den Kosten, fällt die Förderung unterschiedlich aus.</h3>
        <p>Die Förderquote bezieht sich auf die förderfähigen Ausgaben, je nach Anzahl der Wohnungen im Gebäude: 1. Wohnung bis zu 30.000&nbsp;&euro;, 2. bis 6. Wohnung je 15.000&nbsp;&euro;, ab der 7. Wohnung je 8.000&nbsp;&euro;.</p>
      </div>
    </div>

    <div class="row mt-5">

      <!-- Wärmepumpe -->
      <div class="col-md-4 border-end">
        <div class="text-center mb-3">
          <img src="pix/waerrmepumpe.png" class="img-fluid d-block mx-auto" style="max-width: 80%;" alt="Wärmepumpe">
        </div>
        <h3 class="text-center"><strong>Wärmepumpe</strong></h3>
        <ul>
          <li>30&nbsp;% Zuschuss für eine Luft-Wärmepumpe</li>
          <li>35&nbsp;% Zuschuss für eine Luft-Wärmepumpe mit natürlichem Kältemittel</li>
          <li>35&nbsp;% Zuschuss für eine Erdwärmepumpe, Sole- oder Abwasserwärmepumpe</li>
          <li>Plus 20&nbsp;% <strong>Klimageschwindigkeits-Bonus</strong> für selbstnutzende Eigentümer bei vorzeitigem Austausch bestimmter alter, ineffizienter Heizungen</li>
          <li>Plus 30&nbsp;% (max. 70&nbsp;%) Einkommens-Bonus für selbstnutzende Eigentümer, deren durchschnittliches, zu versteuerndes Haushaltsjahreseinkommen 40.000&nbsp;&euro; nicht übersteigt</li>
        </ul>
      </div>

      <!-- Biomasse -->
      <div class="col-md-4">
        <div class="text-center mb-3">
          <img src="pix/pelletheizung.png" class="img-fluid d-block mx-auto" style="max-width: 80%;" alt="Pelletheizung">
        </div>
        <h3 class="text-center"><strong>Biomasse (Holz/Pellet)</strong></h3>
        <ul>
          <li>30&nbsp;% Zuschuss für eine Holz-/Pelletheizung</li>
          <li>Plus <strong>2.500&nbsp;&euro; Emissionsminderungszuschlag</strong> für Holz-/Pelletheizungen, die die geforderten Staubemissionswerte einhalten</li>
          <li>Plus 20&nbsp;% <strong>Klimageschwindigkeits-Bonus</strong> für selbstnutzende Eigentümer bei vorzeitigem Austausch bestimmter alter, ineffizienter Heizungen, wenn die neue Holz-/Pelletheizung mit einer Wärmepumpe, Solarthermie oder PV zur Warmwasserbereitung kombiniert wird</li>
          <li>Plus 30&nbsp;% (max. 70&nbsp;%) Einkommens-Bonus für selbstnutzende Eigentümer, deren durchschnittliches, zu versteuerndes Haushaltsjahreseinkommen 40.000&nbsp;&euro; nicht übersteigt</li>
        </ul>
      </div>

      <!-- Wärmenetz -->
      <div class="col-md-4 border-start">
        <div class="text-center mb-3">
          <img src="pix/waermenetz.png" class="img-fluid d-block mx-auto" style="max-width: 80%;" alt="Wärmenetz">
        </div>
        <h3 class="text-center"><strong>Anschluss an ein Wärmenetz</strong></h3>
        <ul>
          <li>30&nbsp;% Zuschuss für den Anschluss an Fernwärme, Nahwärme oder an ein Gebäudenetz</li>
          <li>Plus 20&nbsp;% <strong>Klimageschwindigkeits-Bonus</strong> für selbstnutzende Eigentümer bei vorzeitigem Austausch bestimmter alter, ineffizienter Heizungen</li>
          <li>Plus 30&nbsp;% (max. 70&nbsp;%) Einkommens-Bonus für selbstnutzende Eigentümer, deren durchschnittliches, zu versteuerndes Haushaltsjahreseinkommen 40.000&nbsp;&euro; nicht übersteigt</li>
        </ul>
      </div>

    </div>
  </div>
</section>