<?php

$error= array();
$data = array();
if($_POST){
	$data  = $_POST;
	if (empty($_POST["adresse"])) $error[] = "adresse";
	if (empty($_POST["email"]) || !filter_var($_POST["email"], FILTER_VALIDATE_EMAIL)) $error[] = "email";
	if (empty($_POST["name"])) $error[] = "name";
	if (empty($_POST["telefon"])) $error[] = "tel";
	if (empty($_POST["anfrage"]))  $error[] = "anfrage";	
	if (empty($_POST["datenschutz"]))  $error[] = "datenschutz";
	
	if(empty($error)){
		$contactEmail = $partnerMail;
		$sender = "info@foerderdata.de";
		$subject = "Starpool Fach-Anbindung Formular Anfrage";
		if($contactEmail) {
		
      $headers  = "MIME-Version: 1.0" . "\r\n";
      $headers .= "Content-type: text/html; charset=UTF-8" . "\r\n";
      $headers .= "From: $sender" . "\r\n";


			$timestamp = time();
			$datum = date("d.m.Y  H:i", $timestamp);
			$html ='
			Anfragedatum : '.$datum.'<br>
			Name : '.$data["name"].'<br>
			
			Adresse : '.$data["adresse	"].'<br>
			E-Mail : '.$data["email"].'<br>
			Telefon-/Mobilnummer : '.$data["telefon"].'<br>
			Anfrage : '.$data["anfrage"].'<br>';

      $html = '
      <html>
      <head>
        <title>Anfrage</title>
      </head>
      <body>
        <h1 style="color: #2b5b94;">Kontakt</h1><br>
        '.$html.'
      </body>
      </html>
      ';
			
			mail($contactEmail, $subject, $html, $headers, "-f$sender");

      $dt = new DateTime();		
			$db = new SQLite3(partnerDB);	

      $partnerRes = $db->query("insert into contact (customer_id,email,created_at,content) values (".
      $db->escapeString($id).",
      '".$db->escapeString($contactEmail)."',
      '".$db->escapeString($dt->format('d.m.Y H:i:s'))."',
      '".$db->escapeString($html)."')");

			echo '<div id="main" class="container">
					<div class="content">
						<h2>Vielen Dank für Ihre unverbindliche Anfrage</h2><br>
						<div>Wir nehmen schnellstmöglich Kontakt mit Ihnen auf</div>	
						<a class="btn btn-primary mt-4" href="Ueber-Uns">Zurück</a>
					</div>
				  </div>';
			exit;
		}
	}
}

?>


<section aria-labelledby="kontaktformular" class="py-5">
  <div class="container">
    <div class="row">
      <div class="col-md-12 text-center">
        <h1>Nehmen Sie mit uns Kontakt auf</h1>
        <h3>Nutzen Sie für Ihr Vorhaben rund ums Haus die beste Finanzierung und die maximale Förderung.</h3>
      </div>
    </div>
  </div>
</section>

<section aria-labelledby="kontaktformular" class="py-5 bg-grey">
  <div class="container">
    <form class="needs-validation" action="Kontakt" method="post" novalidate>
      <div class="row">
        <div class="col-md-6 mb-3">
          <label for="name" class="form-label">Name *</label>
          <input type="text" id="name" name="name" class="form-control" required aria-required="true">
          <div class="invalid-feedback">Bitte geben Sie Ihren Namen ein.</div>
        </div>
        <div class="col-md-6 mb-3">
          <label for="email" class="form-label">E-Mail *</label>
          <input type="email" id="email" name="email" class="form-control" required aria-required="true">
          <div class="invalid-feedback">Bitte geben Sie eine gültige E-Mail-Adresse ein.</div>
        </div>
      </div>

      <div class="mb-3">
        <label for="adresse" class="form-label">Adresse *</label>
        <input type="text" id="adresse" name="adresse" class="form-control" required aria-required="true">
        <div class="invalid-feedback">Bitte geben Sie Ihre Adresse ein.</div>
      </div>

      <div class="mb-3">
        <label for="telefon" class="form-label">Telefon *</label>
        <input type="tel" id="telefon" name="telefon" class="form-control" required aria-required="true">
        <div class="invalid-feedback">Bitte geben Sie Ihre Telefonnummer ein.</div>
      </div>

      <div class="mb-3">
        <label for="anfrage" class="form-label">Ihre Anfrage *</label>
        <textarea id="anfrage" name="anfrage" rows="5" class="form-control" required aria-required="true"></textarea>
        <div class="invalid-feedback">Bitte schreiben Sie Ihre Anfrage.</div>
      </div>

      <div class="form-check mb-4">
        <input class="form-check-input" type="checkbox" id="datenschutz" name="datenschutz" required aria-required="true">
        <label class="form-check-label" for="datenschutz">
          Ich habe die <a href="Datenschutz" target="_blank">Datenschutzerklärung</a> gelesen. Ich stimme zu, dass meine Angaben zur Kontaktaufnahme und für Rückfragen benutzt werden dürfen. Ihre Angaben werden nur als SSL-geschützte E-Mail gesendet und nicht in einer Datenbank gespeichert.
        </label>
        <div class="invalid-feedback">Bitte bestätigen Sie den Datenschutz.</div>
      </div>

      <div class="text-center">
        <button type="submit" class="btn btn-warning btn-block">Absenden</button>
      </div>
    </form>
  </div>
</section>
<script>
  (function () {
    'use strict';
    const forms = document.querySelectorAll('.needs-validation');
    Array.from(forms).forEach(function (form) {
      form.addEventListener('submit', function (event) {
        if (!form.checkValidity()) {
          event.preventDefault();
          event.stopPropagation();
        }
        form.classList.add('was-validated');
      }, false);
    });
  })();
</script>
