<?php
require_once 'auth.php';
header('Content-Type: application/json');

try {
    $db = new PDO('sqlite:' . __DIR__ . '../../data/database.sqlite');
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $id = isset($_GET['id']) ? intval($_GET['id']) : 0;

    if ($id > 0) {
        // Einzelner Kunde mit allen Feldern
        $stmt = $db->prepare("SELECT id, firma, ansprechpartner, funktion, strasse, plz, ort, optional, 
           email, telefon, fax, createUser, theme, navi, showPrint, active, uid, ansprechpartner_alt  ,funktion_alt  ,freitext   FROM customers WHERE id = :id");
        $stmt->execute([':id' => $id]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($row) {
            $row['navi'] = json_decode($row['navi'], true);
            $row['logoUrl'] = '/api/getLogo.php?id=' . $row['id'];
            $row['passbildUrl'] = '/api/getPassbild.php?id=' . $row['id'];

            echo json_encode([
                'success' => true,
                'item' => $row,
                'fehler' => ''
            ]);
        } else {
            echo json_encode([
                'success' => false,
                'item' => null,
                'fehler' => 'Kunde nicht gefunden'
            ]);
        }
    } else {
        // Alle Kunden für Listenansicht
        $stmt = $db->query("SELECT id, uid, firma, ansprechpartner, email, active FROM customers ORDER BY firma ASC");
        $customers = [];

        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $customers[] = [
                'id' => $row['id'],
                'uid' => $row['uid'],
                'name' => $row['firma'],
                'ansprechpartner' => $row['ansprechpartner'],
                'email' => $row['email'],
                'active' => intval($row['active'])
            ];
        }

        echo json_encode([
            'success' => true,
            'item' => $customers,
            'fehler' => ''
        ]);
    }
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'item' => [],
        'fehler' => $e->getMessage()
    ]);
}
