<?php
require_once 'auth.php';
header('Content-Type: application/json');

try {
    $db = new PDO('sqlite:' . dirname(__FILE__) . '../../data/database.sqlite');
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
    $title = isset($_POST['title']) ? $_POST['title'] : '';
    $date = isset($_POST['date']) ? $_POST['date'] : '';
    $subheadline = isset($_POST['subheadline']) ? $_POST['subheadline'] : '';
    $altText = isset($_POST['altText']) ? $_POST['altText'] : '';
    $imageCredit = isset($_POST['imageCredit']) ? $_POST['imageCredit'] : '';
    $text = isset($_POST['text']) ? $_POST['text'] : '';

    $mimeType = null;
    if (isset($_FILES['image']) && is_uploaded_file($_FILES['image']['tmp_name'])) {
        $imageBlob = file_get_contents($_FILES['image']['tmp_name']);
        $finfo = new finfo(FILEINFO_MIME_TYPE);
        $mimeType = $finfo->file($_FILES['image']['tmp_name']);
    }

    if ($id === 0) {
        // INSERT
        $stmt = $db->prepare("
            INSERT INTO news 
            (title, date, subheadline, alt_text, image_credit, text, image, mime_type, active)
            VALUES 
            (:title, :date, :subheadline, :altText, :imageCredit, :text, :image, :mimeType, 1)
        ");
        $stmt->bindParam(':mimeType', $mimeType);
        $stmt->bindParam(':title', $title);
        $stmt->bindParam(':date', $date);
        $stmt->bindParam(':subheadline', $subheadline);
        $stmt->bindParam(':altText', $altText);
        $stmt->bindParam(':imageCredit', $imageCredit);
        $stmt->bindParam(':text', $text);
        $stmt->bindParam(':image', $imageBlob, PDO::PARAM_LOB);
    } else {
        // UPDATE
        $sql = "UPDATE news SET 
                    title = :title,
                    date = :date,
                    subheadline = :subheadline,
                    alt_text = :altText,
                    image_credit = :imageCredit,
                    text = :text";
        if ($imageBlob !== null) {
            $sql .= ", image = :image, mime_type = :mimeType";
        }
        $sql .= " WHERE id = :id";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':title', $title);
        $stmt->bindParam(':date', $date);
        $stmt->bindParam(':subheadline', $subheadline);
        $stmt->bindParam(':altText', $altText);
        $stmt->bindParam(':imageCredit', $imageCredit);
        $stmt->bindParam(':text', $text);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        if ($imageBlob !== null) {
            $stmt->bindParam(':image', $imageBlob, PDO::PARAM_LOB);
            $stmt->bindParam(':mimeType', $mimeType);
        }
    }

    $stmt->execute();

    echo json_encode(array('status' => 'success'));
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(array('status' => 'error', 'message' => $e->getMessage()));
}
