<?php
require_once 'auth.php';
header('Content-Type: application/json');

try {
    $db = new PDO('sqlite:' . __DIR__ . '../../data/database.sqlite');
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $data = json_decode(file_get_contents("php://input"), true);
    $id = isset($data['id']) ? intval($data['id']) : 0;

    if ($id > 0) {
        $stmt = $db->prepare("DELETE FROM news WHERE id = :id");
        $stmt->execute([':id' => $id]);

        echo json_encode([
            'success' => true,
            'item' => [],
            'fehler' => ''
        ]);
    } else {
        throw new Exception('Ungültige ID');
    }
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'item' => [],
        'fehler' => $e->getMessage()
    ]);
}
