<?php
session_start();

function getAuthorizationHeader() {
    if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
        return trim($_SERVER['HTTP_AUTHORIZATION']);
    }

    if (function_exists('apache_request_headers')) {
        $headers = apache_request_headers();
        foreach ($headers as $key => $value) {
            if (strtolower($key) === 'authorization') {
                return trim($value);
            }
        }
    }

    return null;
}

function isAuthenticated() {
    $authHeader = getAuthorizationHeader();
    if (!$authHeader) return false;

    if (preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
        $token = $matches[1];

        // Token mit aktueller Session-ID vergleichen
        if ($token !== session_id()) {
            session_write_close(); // aktuelle Session schließen
            session_id($token);    // Token als Session-ID setzen
            session_start();       // neue Session starten
        }

        // Nun prüfen, ob die Session als eingeloggt markiert ist
        return isset($_SESSION['authenticated']) && $_SESSION['authenticated'] === true;
    }

    return false;
}

if (!isAuthenticated()) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Nicht autorisiert']);
    exit;
}