import axios from 'axios'

const baseURL =
  import.meta.env.MODE === 'development'
    ? '/api/' // dev: Proxy regelt Weiterleitung
    : import.meta.env.VITE_BASE + 'api/'; // staging: z. B. /frontend/starpool/admin/api/

const api = axios.create({
  baseURL
})

// Token automatisch mitsenden
api.interceptors.request.use(config => {
  const token = localStorage.getItem('token')
  if (token) {
    config.headers.Authorization = `Bearer ${token}`
  }
  return config
})

// 🔐 401 automatisch abfangen und weiterleiten
api.interceptors.response.use(
  response => response,
  error => {
    if (error.response && error.response.status === 401) {
      localStorage.removeItem('token') // optional
      router.push('/login') // ⬅️ zur Login-Seite umleiten
    }
    return Promise.reject(error)
  }
)

export default api
